﻿using System;
using System.Web;
using System.Web.UI.WebControls;

using VIRP_WEB.BaseCode;
using VIRP.EFR.BO;

namespace VIRP_WEB.Custom.EFR
{
    public partial class Referrals : EfrBasePage
    {
        protected override void Page_Load(object sender, EventArgs e)
        {
            Session["statusId"] = SessionItemFactory.Create(Request.Params.Get("statusId") ?? "4");

            if (!IsPostBack)
            {
                pnlModalPanel.Visible = false;
                GridViewEFRReferrals.Visible = true;

                int statusId = 0;

                if (int.TryParse(Request.QueryString["statusId"], out statusId))
                {
                    Session["ReferralListing.sortColumn"] = SessionItemFactory.Create("REFERRAL_ID");
                    Session["ReferralListing.sortOrder"] = SessionItemFactory.Create("Descending");

                    HiddenFieldClearFlag.Value = "0";

                    //Set the page title
                    if (statusId == 4)
                    {
                        ((Label)Master.FindControl("EfrPageTitle")).Text = "My Tasks > Referrals > New";
                    }
                    else if (statusId == 5)
                    {
                        ((Label)Master.FindControl("EfrPageTitle")).Text = "My Tasks > Referrals > Open";
                    }
                    else if (statusId == 6)
                    {
                        ((Label)Master.FindControl("EfrPageTitle")).Text = "My Tasks > Referrals > Closed";
                    }
                    else if (statusId == 9)
                    {
                        ((Label)Master.FindControl("EfrPageTitle")).Text = "My Tasks > Referrals > Ineligible";
                    }
                    else
                    {
                        ((Label)Master.FindControl("EfrPageTitle")).Text = "My Tasks > Referrals";
                    }
                }

                Session["ReferralListing.statusCode"] = SessionItemFactory.Create(VIRP.EFR.BLL.REFERRALManager.GetStatusCode(statusId));

                SetupCommonDataSourceParameters();
                LoadPreviousSearch();
            }

            // Added for 508 compliance with GridView column headers and footer
            Page.ClientScript.RegisterStartupScript(GetType(), "UpdateGridView", "UpdateGridView('" + GridViewEFRReferrals.ClientID + "');", true);
        }

        private void SetupCommonDataSourceParameters()
        {
            var currentUser = HttpContext.Current.User.Identity.Name;
            ObjectDataSourceReferralsSearch.SelectParameters["CURRENT_USER"].DefaultValue = currentUser;

            var currentRegistry = UserSession.CurrentRegistryId.ToString();
            ObjectDataSourceReferralsSearch.SelectParameters["CURRENT_REGISTRY_ID"].DefaultValue = currentRegistry;

            var statusCode = SessionItemValue.Get(Session["ReferralListing.statusCode"]);
            if (!string.IsNullOrEmpty(statusCode))
            {
                ObjectDataSourceReferralsSearch.SelectParameters["REFERRAL_STATUS_CODE"].DefaultValue = statusCode;
            }
            else
            {
                ObjectDataSourceReferralsSearch.SelectParameters["REFERRAL_STATUS_CODE"].DefaultValue = "EFR_NEW";
            }
        }

        private void LoadPreviousSearch()
        {
            string lastNameSearch = SessionItemValue.Get(Session["Referral_Search_Last_Name"]);
            if (!string.IsNullOrEmpty(lastNameSearch))
            {
                TextBoxPatientLastNameSearch.Text = lastNameSearch;
            }
        }

        private void SaveCurrentSearchFields()
        {
            if (!string.IsNullOrEmpty(TextBoxPatientLastNameSearch.Text))
                Session["Referral_Search_Last_Name"] = SessionItemFactory.Create(TextBoxPatientLastNameSearch.Text);
            else
                Session.Remove("Referral_Search_Last_Name");
        }

        private void Search()
        {
            GridViewEFRReferrals.DataBind();

            SaveCurrentSearchFields();
        }

        protected void ReferralView_RowCommand(object sender, GridViewCommandEventArgs e)
        {
            if (e.CommandName == "Details")
            {
                int index = Convert.ToInt32(e.CommandArgument);
                GridViewEFRReferrals.SelectedIndex = index;
                int id = Convert.ToInt32(GridViewEFRReferrals.SelectedValue);

                string url = "referral.aspx?referralId=" + id + "&statusId=" + Helpers.SessionItemValueGet(Session["statusId"]); 

                Response.Redirect(url);
            }
        }

        protected void ButtonClear_Click(object sender, EventArgs e)
        {
            TextBoxPatientLastNameSearch.Text = string.Empty;
            HiddenFieldClearFlag.Value = "1";

            Search();
        }

        protected void ButtonOK_Click(object sender, EventArgs e)
        {
            GridViewEFRReferrals.PageIndex = 0;
            HiddenFieldClearFlag.Value = "0";

            Search();
        }
    }
}
